/*
** Source Lines of Code Counter      (c) Copyright IBM Corp., 1987,1992
**                                   For Internal Use Only
**    by: Jeffrey W. Hamilton  (JEFFH at WMAVM7)
*/

#include "global.h"

/*
** Determine if the given template matches a string of characters.
*/
int match(char *template, char *actual)
{
   char *temp,*act;
   char *mark = NULL;
   int skip_mode = 0;

   temp = template;
   act = actual;
   while (*act != '\0') {
      if (*temp == '*') {
         /* start skipping */
         temp++;
         skip_mode = 1;
      } else if (*temp == '?') {
         /* skip one character */
         temp++;
         act++;
      } else if (skip_mode == 0) {
         /* Looking for an exact match */
#ifdef OS_AIX
         if (*temp == *act) {
#else
         if (tolower(*temp) == tolower(*act)) {
#endif
            temp++;
            act++;
         } else if (mark != NULL) {
            temp = mark;
            act++;
         } else {
            return(0);
         }
      } else {
         /* In skip mode, looking for end */
#ifdef OS_AIX
         if (*temp == *act) {
#else
         if (tolower(*temp) == tolower(*act)) {
#endif
            skip_mode = 0;
            mark = temp;
            temp++;
            act++;
         } else {
            act++;
         }
      }
   }
   if (*temp == '*') {
      temp++;
   }
   if ((*temp == ' ') || (*temp == '\n') || (*temp == '\0')) {
      /* entire template consumed */
      return(1);
   } else {
      return(0);
   }
}

/*
** Print a report based on a template given by the user.
*/
void print_report(FILE *fp)
{
   char string[256];
   int subtotal_files;
   long subtotal_lines;
   long subtotal_comments;
   long subtotal_code;
   sym_list *temp_list;

   while (!feof(fp)) {
      fgets(string,255,fp);
      if ((string[0] == '+') || (string[0] == '-')) {
         /* new subtotal requested */
         subtotal_lines = 0;
         subtotal_comments = 0;
         subtotal_code = 0;
         subtotal_files = 0;
         while ((!feof(fp)) && ((string[0] == '+') || (string[0] == '-'))) {
            /* accumulate subtotals */
            for (temp_list = counts; temp_list != NULL; temp_list = temp_list->next) {
               if (match(&string[1],temp_list->name)) {
                  if (string[0] == '+') {
                     /* add file statistics to subtotal */
                     subtotal_files += 1;
                     subtotal_lines += temp_list->lines;
                     subtotal_comments += temp_list->comments;
                     subtotal_code += temp_list->code;
                  } else {
                     /* Subtract file statistics to subtotal */
                     subtotal_files -= 1;
                     subtotal_lines -= temp_list->lines;
                     subtotal_comments -= temp_list->comments;
                     subtotal_code -= temp_list->code;
                  }
               }
            }
            fgets(string,255,fp);
         }
         fprintf(output,"Total Number of Files: %u\n",subtotal_files);
         fprintf(output,"   Physical Lines: %ld\n",subtotal_lines);
         fprintf(output,"   Lines of Comments: %ld\n",subtotal_comments);
         fprintf(output,"   Number of Source Lines of Code: %ld\n", subtotal_code);
      }
      if (!feof(fp)) {
         fprintf(output,"%s",string);
      }
   }
   fprintf(output,"\f");
}
